#!/bin/bash

# --- 1. Blacklisting av TV-drivere ---
echo "Konfigurerer kernel-moduler (Blacklisting)..."
sudo bash -c 'cat <<EOF > /etc/modprobe.d/blacklist-rtl.conf
blacklist dvb_usb_rtl28xxu
blacklist rtl2832
blacklist rtl2832_sdr
EOF'
sudo modprobe -r dvb_usb_rtl28xxu rtl2832_sdr rtl2832 2>/dev/null

# --- 2. Systemoppdatering ---
echo "Oppdaterer pakkelister..."
sudo apt update

# --- 3. Individuell installasjon (Robust modus) ---
echo "Installerer systempakker individuelt..."
sudo apt install -y nodejs
sudo apt install -y npm
sudo apt install -y rtl-sdr
sudo apt install -y sox
sudo apt install -y libsox-fmt-all
sudo apt install -y python3-pip
sudo apt install -y ffmpeg  # Trengs av gTTS for å konvertere mp3 til wav
sudo apt install -y multimon-ng

# --- 4. Node-verktøy ---
echo "Installerer PM2..."
sudo npm install -g pm2

# --- 5. Python-biblioteker ---
echo "Installerer Python-avhengigheter..."
if command -v pip &> /dev/null; then
    pip install gtts python-dotenv --break-system-packages
else
    echo "[!] Pip ble ikke funnet, prøver med python3 -m pip"
    python3 -m pip install gtts python-dotenv --break-system-packages
fi

# --- 6. Prosjekt-oppsett ---
echo "Pakker ut prosjektfilene..."
tar -xzf ra_project.tar.gz -C /home/pi/ 2>/dev/null

# --- 7. Start med PM2 ---
echo "Starter radio_scan.py med PM2..."
cd /home/pi/radio_audio
# Sørger for at PM2 starter ved boot
sudo env PATH=$PATH:/usr/bin /usr/lib/node_modules/pm2/bin/pm2 startup systemd -u pi --hp /home/pi
# Sletter gammel instans hvis den finnes og starter på nytt
pm2 delete "radio-scanner" 2>/dev/null
pm2 start radio_scan.py --interpreter python3 --name "radio-scanner" --update-env
pm2 save

# --- 8. Konfigurerer Crontab (Lyd, Arkivering og Backup) ---
echo "Setter opp Crontab..."
cat <<EOF > /tmp/cron_setup
# --- LYDSTYRING (Volum Av/På) ---
30 22 * * 1-5 amixer -D hw:UACDemoV10 sset 'PCM' 0%
30 06 * * 1-5 amixer -D hw:UACDemoV10 sset 'PCM' 80%
30 22 * * 6,0 amixer -D hw:UACDemoV10 sset 'PCM' 0%
00 08 * * 6,0 amixer -D hw:UACDemoV10 sset 'PCM' 80%

# --- ARKIVERING (Hver time) ---
0 * * * * /usr/bin/python3 /home/pi/radio_audio/archive_radio.py >> /home/pi/radio_audio/log.txt 2>&1

# --- AUTOMATISK BACKUP (Ukentlig søndager kl 23:00) ---
0 23 * * 0 /usr/bin/python3 /home/pi/radio_audio/upload_ra_backup.py >> /home/pi/radio_audio/backup_log.txt 2>&1
EOF

# Installerer den nye crontab-filen
crontab /tmp/cron_setup
rm /tmp/cron_setup

echo "-------------------------------------------------------"
echo "Installasjon fullført!"
echo "Crontab er oppdatert med lydstyring, arkivering og backup."
echo "Husk: 'sudo reboot' anbefales for å aktivere blacklist."
echo "-------------------------------------------------------"
