import subprocess
import sys
import os
import time
from datetime import datetime

def install_dependencies():
    """Sjekker og installerer nødvendig programvare på din Pi."""
    packages = {
        "rtl_fm": "rtl-sdr",
        "multimon-ng": "multimon-ng"
    }
    
    for cmd, pkg in packages.items():
        try:
            subprocess.run([cmd, "-h"], stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        except FileNotFoundError:
            print(f"[*] Installerer {pkg} for din Raspberry Pi...")
            subprocess.run(["sudo", "apt-get", "update"], check=True)
            subprocess.run(["sudo", "apt-get", "install", "-y", pkg], check=True)

def run_navtex_receiver():
    # Stasjon L (Rogaland Radio) sender ca. kl: 01:50, 05:50, 09:50, 13:50, 17:50, 21:50 (UTC)
    # Husk at lokal tid i Norge er UTC+1 (vinter) eller UTC+2 (sommer).
    
    logfile = "navtex_logg.txt"
    print(f"--- Starter NAVTEX-mottak på 518 kHz ---")
    print(f"Bruker: RTL-SDR V3 i HF-modus (-D 2)")
    print(f"Logger til: {os.path.abspath(logfile)}")
    print("Trykk Ctrl+C for å stoppe.\n")

    # Forklaring av flaggene for din sølvgrå V3-pinne:
    # -f 518000: Frekvens 518 kHz
    # -M am: Bruker AM-modulasjon (nødvendig for HF-sampling)
    # -s 22050: Samplerate som multimon-ng liker
    # -D 2: VIKTIG! Aktiverer Direct Sampling (HF) på din V3-modell
    # -p 0: PPM-korreksjon (V3 har TCXO, så 0 er som regel riktig)
    
    cmd = "rtl_fm -f 518000 -M am -s 22050 -D 2 -p 0 | multimon-ng -a NAVTEX -t raw -v 1 /dev/stdin"

    try:
        # Åpner en rørledning til multimon-ng
        process = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
        
        with open(logfile, "a") as f:
            f.write(f"\n--- Sesjon startet: {datetime.now()} ---\n")
            for line in process.stdout:
                # Skriv ut til skjerm (terminal)
                sys.stdout.write(line)
                # Lagre til fil hvis linjen inneholder data
                if line.strip():
                    f.write(f"{datetime.now().strftime('%H:%M:%S')} - {line}")
                    f.flush()
                    
    except KeyboardInterrupt:
        print("\nStopper mottaker...")
        process.terminate()

if __name__ == "__main__":
    # Sjekk om vi kjører på en Pi og har verktøyene
    install_dependencies()
    
    # Start lytting
    run_navtex_receiver()
