import sys
import os

def monitor_navtex():
    print("Lytter etter NAVTEX-meldinger (ZCZC)...")
    buffer = ""
    is_recording = False
    message_content = ""

    try:
        while True:
            # Vi leser rådata fra stdin (pipet fra rtl_sdr)
            raw_data = sys.stdin.read(1)
            if not raw_data:
                break
            
            # Legg til i buffer og hold den kort
            buffer += raw_data
            if len(buffer) > 100:
                buffer = buffer[-100:]

            # Se etter start-kode
            if "ZCZC" in buffer and not is_recording:
                print("\n--- START PÅ MELDING DETEKTERT ---")
                is_recording = True
                message_content = "ZCZC"
                buffer = ""

            if is_recording:
                message_content += raw_data
                
                # Se etter slutt-kode
                if "NNNN" in message_content:
                    print("--- MELDING FULLFØRT OG LAGRET ---")
                    with open("navtex_log.txt", "a") as f:
                        f.write("\n--- NY MELDING ---\n")
                        f.write(message_content)
                        f.write("\n------------------\n")
                    is_recording = False
                    message_content = ""

    except KeyboardInterrupt:
        print("\nStopper overvåking.")

if __name__ == "__main__":
    monitor_navtex()
