#!/bin/bash

# 1. Stopp gamle prosesser
sudo killall -9 rtl_test python3 2>/dev/null
sleep 2

# 2. Rotering av logg
if [ -f ~/navtex_output.log ]; then
    tail -n 1000 ~/navtex_output.log > ~/navtex_output.log.tmp && mv ~/navtex_output.log.tmp ~/navtex_output.log
fi

# 3. Lås hardware til 518kHz
rtl_sdr -f 518000 -s 256000 -g 45 -D 2 -n 1 /dev/null

# 4. Start bakgrunnsprosess
nohup sh -c "rtl_test -b 1 -s 256000 2>/dev/null | python3 -u /home/pi/radio_audio/scripts/nav_decoder.py" >> /home/pi/navtex_output.log 2>&1 &

echo "Systemet er startet."
