#!/bin/bash

# --- FUNKSJON FOR Å STARTE ALT IGJEN ---
avslutt_og_restart_services() {
    echo ""
    echo "=================================================="
    echo "   Avslutter strømming... Rydder opp!             "
    echo "=================================================="
    
    # 1. Start AIS igjen
    pm2 start all
    
    # 2. Start OpenWebRX igjen (Valgfritt)
    # sudo /usr/bin/docker start openwebrx
    
    echo "-> Tjenester starter opp..."
    sleep 2
    
    echo ""
    echo "STATUS OVERSIKT:"
    pm2 list
    
    echo ""
    echo "-> Alt er tilbake til normalen. Takk for nå!"
}

trap avslutt_og_restart_services EXIT INT

# --- HOVEDSCRIPTET ---

echo "=================================================="
echo "   Klargjør for MagicSDR / SDR++ (TCP)            "
echo "=================================================="

# 1. Stopp OpenWebRX (Docker) - BRUTE FORCE
echo "[1/5] Stopper OpenWebRX..."
sudo /usr/bin/docker stop openwebrx > /dev/null 2>&1 || true

# 2. Stopp AIS (PM2)
echo "[2/5] Stopper AIS..."
pm2 stop all > /dev/null 2>&1

# 3. Drep eventuelle "Zombier" (Viktig!)
echo "[3/5] Dreper gamle prosesser..."
sudo killall -9 rtl_tcp > /dev/null 2>&1 || true
sudo killall -9 rtl_ais > /dev/null 2>&1 || true

# 4. Spark ut Kernel-driveren (Kuren mot Error -6)
echo "[4/5] Tvinger ut USB-drivere..."
sudo rmmod dvb_usb_rtl28xxu > /dev/null 2>&1 || true
sudo rmmod rtl2832 > /dev/null 2>&1 || true
sudo rmmod rtl2830 > /dev/null 2>&1 || true

# 5. Vent litt lenger
echo "[5/5] Venter 5 sekunder på at USB skal roe seg..."
sleep 5

# 6. Sjekk installasjon
if ! command -v rtl_tcp >/dev/null 2>&1; then
    echo "Installerer rtl-sdr..."
    sudo apt update && sudo apt install rtl-sdr -y
fi

# 7. Start Server
IP_ADDRESS=$(hostname -I | awk '{print $1}')

echo ""
echo "[START] Starter rtl_tcp server..."
echo "=================================================="
echo "   KOBLE TIL MAGICSDR NÅ:"
echo "   IP:   $IP_ADDRESS"
echo "   Port: 1234"
echo ""
echo "   Trykk Ctrl+C for å avslutte."
echo "=================================================="

# Start serveren
rtl_tcp -a 0.0.0.0
