#!/bin/bash
set -e
echo "--- Starter full, automatisert installasjon og konfigurasjon ---"

# --- DEL 1: INSTALLASJON AV PROGRAMVARE ---
echo "STEP 1: Installerer all systemprogramvare..."
sudo apt-get update && sudo apt-get -y upgrade

sudo apt-get install -y nodejs git cmake build-essential libusb-1.0-0-dev mpg123 vsftpd chromium-driver chromium python3-pip pkg-config librtlsdr-dev apache2

echo "STEP 2: Installerer og konfigurerer PM2..."
sudo npm install -g pm2
sudo env PATH=$PATH:/usr/local/bin:/usr/bin pm2 startup systemd -u pi --hp /home/pi

# NYTT: Installerer loggrotasjon for PM2
echo "STEP 3: Installerer loggrotasjon for PM2..."
pm2 install pm2-logrotate
pm2 set pm2-logrotate:max_size 10M

echo "STEP 4: Installerer alle Python-pakker..."
sudo python3 -m pip install --ignore-installed requests haversine pytz pychromecast gtts python-dotenv mysql-connector-python selenium "urllib3==1.26.18" flask flask_cors psutil pyais duckduckgo_search --break-system-packages

echo "STEP 5: Bygger rtl-ais..."
cd /home/pi; rm -rf rtl-ais; git clone https://github.com/dgiardini/rtl-ais.git
cd rtl-ais; make; sudo make install

# --- DEL 2: RESTAURERING OG KONFIGURASJON AV DITT PROSJEKT ---

echo "STEP 6: Pakker ut og gjenoppretter prosjektfilene dine..."
FILE_TO_UNPACK="/home/pi/ais_project.tar.gz"
if [ -f "$FILE_TO_UNPACK" ]; then
    # NYTT: Stopper alle kjørende PM2-prosesser før utpakking
    echo "   -> Stopper alle eksisterende PM2-prosesser..."
    pm2 stop all || true # '|| true' forhindrer at scriptet stopper hvis ingen prosesser kjører
    sudo tar -xzvf "$FILE_TO_UNPACK" -C /
else
    echo "FEIL: Finner ikke '$FILE_TO_UNPACK'. Avslutter."
    exit 1
fi

AIS_DIR="/home/pi/ais"

echo "STEP 7: Setter opp crontab-jobber..."
cat > /tmp/crontab.tmp << EOF
*/5 * * * * cd ${AIS_DIR} && /usr/bin/python3 health_check.py >> health_check.log 2>&1
5 0 * * * cd ${AIS_DIR} && /usr/bin/python3 image_updater.py >> image_updater.log 2>&1
0 */6 * * * cd ${AIS_DIR} && /usr/bin/python3 get_shipinfo.py >> get_shipinfo.log 2>&1
0 1 * * 1 cd ${AIS_DIR} && /usr/bin/python3 upload_via_ftp.py >> upload_via_ftp.log 2>&1
EOF
crontab /tmp/crontab.tmp
rm /tmp/crontab.tmp

# STEP 8: Starter dine PM2-prosesser (KORRIGERT)
echo "STEP 8: Starter dine PM2-prosesser..."
pm2 start ${AIS_DIR}/ais_to_json.py --name ais-collector
pm2 start ${AIS_DIR}/ship_alert.py --name ship_alert
pm2 start ${AIS_DIR}/api_ais_server.py --name stream_ais

echo "STEP 9: Lagrer PM2-oppsettet..."
pm2 save

echo ""
echo "--- ALT ER NÅ FERDIG OPP SATT! ---"
echo "Systemet er gjenopprettet og kjører med loggrotasjon aktivert."
