import ftplib
import os
import tarfile
import glob
from datetime import datetime
from dotenv import load_dotenv

# --- KONFIGURASJON ---
load_dotenv('/home/pi/key_info.env')

FTP_HOST = "totland.org"
FTP_USER = os.getenv("FTP_USER")
FTP_PASS = os.getenv("FTP_PASSWORD")
REMOTE_DIR = "/public_html/kjetil/radio_backup/" 

TIMESTAMP = datetime.now().strftime("%Y%m%d_%H%M")
ARCHIVE_NAME = f"full_ais_backup_{TIMESTAMP}.tar.gz"

# Definerer områdene som skal inkluderes
AIS_DIR = "/home/pi/ais"           # Programlogikk
WEB_DIR = "/var/www/html"          # Nettside/Kart
HOME_FILES = "/home/pi/*.*"        # Filer direkte i hjemmemappen

def create_archive():
    try:
        print(f"--- Starter pakking av backup ---")
        with tarfile.open(ARCHIVE_NAME, "w:gz") as tar:
            # 1. Legg til ais mappen
            if os.path.exists(AIS_DIR):
                tar.add(AIS_DIR, arcname="ais")
                print(f"Inkludert: {AIS_DIR}")

            # 2. Legg til html mappen
            if os.path.exists(WEB_DIR):
                tar.add(WEB_DIR, arcname="html")
                print(f"Inkludert: {WEB_DIR}")

            # 3. Legg til enkeltfiler i hjemmemappen
            for file in glob.glob(HOME_FILES):
                if os.path.isfile(file):
                    tar.add(file, arcname=os.path.basename(file))
                    print(f"Inkludert fil: {os.path.basename(file)}")

        print(f"✅ Arkiv opprettet: {ARCHIVE_NAME}")
        return True
    except Exception as e:
        print(f"❌ Feil under pakking: {e}")
        return False

def upload_to_totland():
    if not create_archive():
        return

    try:
        print(f"Kobler til {FTP_HOST}...")
        session = ftplib.FTP(FTP_HOST, FTP_USER, FTP_PASS)
        
        try:
            session.cwd(REMOTE_DIR)
        except:
            session.mkd(REMOTE_DIR)
            session.cwd(REMOTE_DIR)

        print(f"Overfører {ARCHIVE_NAME}...")
        with open(ARCHIVE_NAME, "rb") as file:
            session.storbinary(f"STOR {ARCHIVE_NAME}", file)
        
        session.quit()
        print(f"✅ Opplasting til totland.org er fullført.")
        
        # Rydd opp lokal arkivfil
        if os.path.exists(ARCHIVE_NAME):
            os.remove(ARCHIVE_NAME)
            print(f"Ryddet opp lokal fil.")

    except Exception as e:
        print(f"❌ FTP-feil: {e}")

if __name__ == "__main__":
    upload_to_totland()
