import subprocess
import time
import sys
import signal
import os
import argparse
import threading

# =================================================================
# --- SENTRALE VARIABLER ---
# =================================================================
SNR_BARRIER = 16.0          
SQUELCH_TECHNICAL = "1"     # Ekstremt lav for å tvinge frem lyd
SCAN_DELAY_SEC = "4"        
FORCE_RESET_SEC = 2         
DEFAULT_GAIN = 45           # Samme som din fungerende test

DEFAULT_CHANNELS = {
    "fm": {
        "156.800M": "Kanal 16", "145.675M": "Toåsen", "105.8M": "Radio Latino"
    }
}

def force_release_resources():
    print(f"[*] Stopper prosesser...")
    subprocess.run("pm2 stop all", shell=True, capture_output=True)
    subprocess.run("sudo killall -9 rtl_fm rtl_power rtl_ais aplay 2>/dev/null", shell=True)
    # Tvinger volumet via systemet
    subprocess.run("amixer sset 'Master' 100% >/dev/null 2>&1", shell=True)
    time.sleep(FORCE_RESET_SEC)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--squelch', type=str, default=SQUELCH_TECHNICAL)
    parser.add_argument('--freq', type=str)
    args = parser.parse_args()

    force_release_resources()
    
    # Bygg frekvens-streng
    if args.freq:
        f_args = f"-f {args.freq if 'M' in args.freq.upper() else args.freq+'M'}"
    else:
        f_args = " ".join([f"-f {f}" for f in DEFAULT_CHANNELS["fm"].keys()])

    # VIKTIG: Denne linjen er nå identisk med din manuelle suksess-test
    # Vi fjerner -l (squelch) helt hvis du setter den til 0 for å feilsøke
    sq_cmd = f"-l {args.squelch}" if args.squelch != "0" else ""
    
    # Her bygger vi den nøyaktige kommandoen
    full_cmd = f"rtl_fm {f_args} -M fm -s 12k -r 44100 -g {DEFAULT_GAIN} -l {args.squelch} -t {SCAN_DELAY_SEC} | aplay -r 44100 -f S16_LE -t raw -c 1 -B 500000"
    
    print("\n" + "="*60)
    print("KJØRER KOMMANDO:")
    print(full_cmd)
    print("="*60 + "\n")

    try:
        # Vi kjører uten stderr-omdirigering så vi ser eventuelle feilmeldinger
        subprocess.run(full_cmd, shell=True)
    except KeyboardInterrupt:
        print("\nAvslutter...")
    finally:
        subprocess.run("pm2 start all", shell=True)

if __name__ == "__main__":
    main()