#!/bin/bash
set -e
echo "--- Starter full, automatisert installasjon og konfigurasjon ---"

# --- DEL 1: INSTALLASJON AV PROGRAMVARE ---
echo "STEP 1: Installerer all systemprogramvare..."
sudo apt-get update && sudo apt-get -y upgrade
sudo apt-get install -y nodejs npm git cmake build-essential libusb-1.0-0-dev mpg123 vsftpd chromium-driver chromium python3-pip pkg-config librtlsdr-dev apache2

echo "STEP 2: Installerer og konfigurerer PM2..."
sudo npm install -g pm2
PM2_PATH=$(sudo find / -name "pm2" -type f | grep "/bin/pm2$" | head -n 1) || PM2_PATH="/usr/local/bin/pm2"
sudo env PATH=$PATH:/usr/bin $PM2_PATH startup systemd -u pi --hp /home/pi

echo "STEP 3: Installerer alle Python-pakker..."
sudo python3 -m pip install --ignore-installed requests haversine pytz pychromecast gtts python-dotenv mysql-connector-python selenium "urllib3==1.26.18" flask flask_cors psutil pyais duckduckgo_search --break-system-packages

echo "STEP 4: Bygger rtl-ais..."
cd /home/pi; rm -rf rtl-ais; git clone https://github.com/dgiardini/rtl-ais.git
cd rtl-ais; make; sudo make install

# --- DEL 2: RESTAURERING OG KONFIGURASJON AV DITT PROSJEKT ---

# STEP 5: Pakker ut og gjenoppretter prosjektfilene dine (KORRIGERT)
echo "STEP 5: Pakker ut og gjenoppretter prosjektfilene dine..."
FILE_TO_UNPACK="/home/pi/ais_project.tar.gz"

if [ -f "$FILE_TO_UNPACK" ]; then
    # Bruker sudo for å pakke ut til system-mapper
    sudo tar -xzvf "$FILE_TO_UNPACK" -C /
else
    echo "FEIL: Finner ikke '$FILE_TO_UNPACK'. Avslutter."
    exit 1
fi



echo "STEP 6: Setter opp crontab-jobber..."
# Lager en midlertidig fil med alle crontab-reglene
cat > /tmp/crontab.tmp << EOF
*/5 * * * * /usr/bin/python3 ${AIS_DIR}/health_check.py >> ${AIS_DIR}/health_check.log 2>&1
5 0 * * * /usr/bin/python3 ${AIS_DIR}/image_updater.py >> ${AIS_DIR}/image_updater.log 2>&1
0 */6 * * * /usr/bin/python3 ${AIS_DIR}/get_shipinfo.py >> ${AIS_DIR}/get_shipinfo.log 2>&1
0 1 * * 1 /usr/bin/python3 ${AIS_DIR}/upload_via_ftp.py >> ${AIS_DIR}/upload_via_ftp.log 2>&1
EOF

# Laster den nye filen inn i crontab. Dette overskriver alt, men er trygt her.
crontab /tmp/crontab.tmp
# Sletter den midlertidige filen
rm /tmp/crontab.tmp

echo ""
echo "--- Oppsett av tjenester er fullført! ---"
echo "Kjør 'crontab -l' for å bekrefte at jobbene er lagt til."

echo "STEP 7: Starter dine PM2-prosesser..."
pm2 start ${AIS_DIR}/ais_to_json.py --name ais-collector
pm2 start ${AIS_DIR}/ship_alert.py --name ship_alert
pm2 start ${AIS_DIR}/api_ais_server.py --name stream_ais

echo "STEP 8: Lagrer PM2-oppsettet..."
pm2 save

echo ""
echo "--- ALT ER NÅ FERDIG OPP SATT! ---"
echo "Systemet er gjenopprettet og kjører."
